package cn.ximcloud.homekit.core.starter.util;

import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Slf4j
public class PingUtil {

    private PingUtil() {
    }

    public static CompletableFuture<Boolean> ping(String ipAddress) {
        return ping(ipAddress, 3, TimeUnit.SECONDS);
    }

    public static CompletableFuture<Boolean> ping(String ipAddress, long timeOut, TimeUnit timeUnit) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return InetAddress.getByName(ipAddress).isReachable((int) timeUnit.toMillis(timeOut));
            } catch (IOException e) {
                log.warn("ping ip address [{}] error", ipAddress, e);
                return false;
            }
        });
    }

}
