package cn.ximcloud.homekit.core.starter.entity;

import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

@Data
@NoArgsConstructor
@Entity(name = "ximcloud_homekit_accessory_type")
public class HomeKitAccessoryTypeEntity implements Serializable {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 类型Class全限定名
     */
    @ManyToOne(fetch = FetchType.EAGER)
    private HomeKitAccessoryEntity typeClass;

    /**
     * 类型配置
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "homeKitAccessoryTypeEntity", fetch = FetchType.EAGER)
    private List<HomeKitAccessoryTypeConfigEntity> accessoryTypeConfig;


    /**
     * 多对一 accessory配置
     */
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private HomeKitAccessoryConfigEntity homeKitAccessoryConfigEntity;

}
