package cn.ximcloud.homekit.core.starter.entity;


import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;
import cn.ximcloud.homekit.core.model.ReturnArg;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;

/**
 * AccessoryTypeConfig
 *
 * @author W9004844
 * @since 2020/01/20 16:16
 */

@Data
@NoArgsConstructor
@Entity(name = "ximcloud_homekit_accessory_type_config")
public class HomeKitAccessoryTypeConfigEntity implements Serializable {

    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 方法名
     */
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.LAZY, targetEntity = HomeKitAccessoryMethodEntity.class)
    private HomeKitAccessoryMethodEntity method;

    /**
     * 执行类型
     */
    private InvokeTypeEnum invokeType;

    /**
     * 返回参数
     */
    private ReturnArg returnArg;

    /**
     * 执行主体
     */
    private String invokeBody;

    /**
     * HomeKitAccessoryType
     */
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private HomeKitAccessoryTypeEntity homeKitAccessoryTypeEntity;

}
