package cn.ximcloud.homekit.core.starter.core.accessories.demo;

import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryConfig;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryType;
import cn.ximcloud.homekit.core.model.HomeKitAccessoryTypeConfig;
import cn.ximcloud.homekit.core.model.ReturnArg;
import cn.ximcloud.homekit.core.proxy.HomeKitAccessoryProxyFactory;
import cn.ximcloud.homekit.core.starter.util.annotation.HomeKit;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.accessories.SwitchAccessory;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Slf4j
@HomeKit
public class DemoSwitchAccessory {

    @HomeKit
    @SneakyThrows
    public static HomekitAccessory generateSimpleDemoSwitchAccessory() {
//        base info
        HomeKitAccessoryConfig homeKitAccessoryConfig = new HomeKitAccessoryConfig();
        homeKitAccessoryConfig.setId(Integer.MAX_VALUE - 2);
        homeKitAccessoryConfig.setName(CompletableFuture.completedFuture("XIMCloud 爆炸的开关"));
        homeKitAccessoryConfig.setSerialNumber(CompletableFuture.completedFuture("XIMCloud0.0.1"));
        homeKitAccessoryConfig.setModel(CompletableFuture.completedFuture("巨大的开关"));
        homeKitAccessoryConfig.setManufacturer(CompletableFuture.completedFuture("XIMCloud Works"));
        homeKitAccessoryConfig.setFirmwareRevision(CompletableFuture.completedFuture("0.0.1"));


        List<HomeKitAccessoryTypeConfig> homeKitAccessoryTypeConfig = new ArrayList<>();
        HomeKitAccessoryTypeConfig config = new HomeKitAccessoryTypeConfig();
        config.setMethod(SwitchAccessory.class.getMethod("getSwitchState"));
        config.setInvokeType(InvokeTypeEnum.VALUE);
        ReturnArg arg = new ReturnArg();
        arg.setArg("true");
        config.setReturnArg(arg);
        homeKitAccessoryTypeConfig.add(config);

        config = new HomeKitAccessoryTypeConfig();
        config.setMethod(SwitchAccessory.class.getMethod("setSwitchState", boolean.class));
        config.setInvokeType(InvokeTypeEnum.VALUE);
        config.setInvokeBody("");
        homeKitAccessoryTypeConfig.add(config);

        List<HomeKitAccessoryType> homeKitAccessoryTypes = new ArrayList<>();
        HomeKitAccessoryType homeKitAccessoryType = new HomeKitAccessoryType();
        homeKitAccessoryType.setTypeClass(SwitchAccessory.class);
        homeKitAccessoryType.setAccessoryTypeConfig(homeKitAccessoryTypeConfig);
        homeKitAccessoryTypes.add(homeKitAccessoryType);
        homeKitAccessoryConfig.setHomeKitAccessoryTypes(homeKitAccessoryTypes);
        HomeKitAccessoryProxyFactory homeKitAccessoryProxyFactory = new HomeKitAccessoryProxyFactory(homeKitAccessoryConfig);

        SwitchAccessory switchAccessory = (SwitchAccessory) homeKitAccessoryProxyFactory.newInstance();
        new Thread(() -> {
            boolean flag = true;
            while (true) {
                try {
                    arg.setArg(flag ? "true" : "false");
                    switchAccessory.setSwitchState(flag);
                    flag = !flag;
                    log.info("the demo switch value is now :{}", arg.getArg());
                    TimeUnit.SECONDS.sleep(10);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();

        return switchAccessory;
    }

}
