package cn.ximcloud.homekit.core.starter.core.accessories.demo;

import cn.ximcloud.homekit.core.enums.InvokeTypeEnum;
import cn.ximcloud.homekit.core.model.ReturnArg;
import cn.ximcloud.homekit.core.starter.entity.HomeKitAccessoryConfigEntity;
import cn.ximcloud.homekit.core.starter.entity.HomeKitAccessoryTypeConfigEntity;
import cn.ximcloud.homekit.core.starter.entity.HomeKitAccessoryTypeEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryEntity;
import cn.ximcloud.homekit.core.starter.entity.metadata.HomeKitAccessoryMethodEntity;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAccessoryRepository;
import io.github.hapjava.accessories.FanAccessory;
import lombok.SneakyThrows;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import static cn.ximcloud.homekit.core.utils.CommonUtil.generateMethodString;

@Component
public class DemoHomekitAccessoryBuilder {

    private final HomeKitAccessoryRepository homeKitAccessoryRepository;

    public DemoHomekitAccessoryBuilder(HomeKitAccessoryRepository homeKitAccessoryRepository) {
        this.homeKitAccessoryRepository = homeKitAccessoryRepository;
    }

    @SneakyThrows
    public HomeKitAccessoryConfigEntity buildDemoHomeKitAccessory() {
        HomeKitAccessoryConfigEntity homeKitAccessoryConfig = new HomeKitAccessoryConfigEntity();

//        base config info
        homeKitAccessoryConfig.setId(Integer.MAX_VALUE - 3);
        homeKitAccessoryConfig.setName("XIMCloud 电风扇");
        homeKitAccessoryConfig.setSerialNumber("0.0.1");
        homeKitAccessoryConfig.setModel("0.0.1");
        homeKitAccessoryConfig.setManufacturer("0.0.1");
        homeKitAccessoryConfig.setFirmwareRevision("0.0.1");
        homeKitAccessoryConfig.setDescription("XIMCloud 电风扇");


        List<HomeKitAccessoryTypeEntity> homeKitAccessoryTypes = new ArrayList<>();

//        setAccessory Type to FanAccessory.class
        HomeKitAccessoryTypeEntity homeKitAccessoryType = new HomeKitAccessoryTypeEntity();
        Optional<HomeKitAccessoryEntity> fanAccessory = homeKitAccessoryRepository.findByClazz(FanAccessory.class);
        HomeKitAccessoryEntity homeKitAccessoryEntity;
        if (fanAccessory.isPresent()) {
            homeKitAccessoryEntity = fanAccessory.get();
            homeKitAccessoryType.setTypeClass(homeKitAccessoryEntity);
        } else {
            throw new IllegalArgumentException("HomeKitAccessoryEntity fanAccessory not found!");
        }

//        add TypeConfig to homeKitAccessoryType
        List<HomeKitAccessoryTypeConfigEntity> homeKitAccessoryTypeConfigs = new ArrayList<>();

//        set method
        HomeKitAccessoryTypeConfigEntity homeKitAccessoryTypeConfig = new HomeKitAccessoryTypeConfigEntity();
        homeKitAccessoryTypeConfig.setHomeKitAccessoryTypeEntity(homeKitAccessoryType);
        String isActiveMethodName = generateMethodString(FanAccessory.class.getDeclaredMethod("isActive"));
        Optional<HomeKitAccessoryMethodEntity> methodEntityOptional = homeKitAccessoryEntity.getHomekitAccessoryMethodList().stream()
                .filter(method -> method.getEnhancedMethodName().equals(isActiveMethodName))
                .findFirst();
        if (methodEntityOptional.isPresent()) {
            homeKitAccessoryTypeConfig.setMethod(methodEntityOptional.get());
        } else {
            throw new IllegalArgumentException("HomeKitAccessoryMethodEntity not found!");
        }
        homeKitAccessoryTypeConfig.setInvokeType(InvokeTypeEnum.VALUE);
        ReturnArg returnArg = new ReturnArg();
        returnArg.setArg("true");
        homeKitAccessoryTypeConfig.setReturnArg(returnArg);
        homeKitAccessoryTypeConfig.setInvokeBody(null);
        homeKitAccessoryTypeConfigs.add(homeKitAccessoryTypeConfig);

//        set method
        homeKitAccessoryTypeConfig = new HomeKitAccessoryTypeConfigEntity();
        homeKitAccessoryTypeConfig.setHomeKitAccessoryTypeEntity(homeKitAccessoryType);
        String setActiveMethodName = generateMethodString(FanAccessory.class.getDeclaredMethod("setActive", boolean.class));
        methodEntityOptional = homeKitAccessoryEntity.getHomekitAccessoryMethodList().stream()
                .filter(method -> method.getEnhancedMethodName().equals(setActiveMethodName))
                .findFirst();
        if (methodEntityOptional.isPresent()) {
            homeKitAccessoryTypeConfig.setMethod(methodEntityOptional.get());
        } else {
            throw new IllegalArgumentException("HomeKitAccessoryMethodEntity not found!");
        }
        homeKitAccessoryTypeConfig.setInvokeType(InvokeTypeEnum.NOT_INVOKE);
        homeKitAccessoryTypeConfig.setReturnArg(null);
        homeKitAccessoryTypeConfig.setInvokeBody(null);
        homeKitAccessoryTypeConfigs.add(homeKitAccessoryTypeConfig);

        homeKitAccessoryType.setAccessoryTypeConfig(homeKitAccessoryTypeConfigs);
        homeKitAccessoryType.setHomeKitAccessoryConfigEntity(homeKitAccessoryConfig);
        homeKitAccessoryTypes.add(homeKitAccessoryType);
        homeKitAccessoryConfig.setHomeKitAccessoryTypes(homeKitAccessoryTypes);
        return homeKitAccessoryConfig;
    }
}
