package cn.ximcloud.homekit.core.starter.autoconfig.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static cn.ximcloud.homekit.core.starter.autoconfig.properties.HomeKitProperties.HOMEKIT_CONFIG;


/**
 * XIMCloud HomeKit Config
 *
 * @author wizard
 */
@Data
@ConfigurationProperties(prefix = HOMEKIT_CONFIG)
public class HomeKitProperties {

    public static final String HOMEKIT_CONFIG = "ximcloud.homekit";

    /**
     * IP地址
     */
    private String ipAddress;


    /**
     * apple homekit 端口默认9123
     */
    private Integer port = 9123;

    /**
     * 标签
     * label for the bridge. This will show in iOS during pairing.
     */
    private String label;

    /**
     * 制造商
     * manufacturer of the bridge. This information is exposed to iOS for unknown
     * purposes.
     */
    private String manufacturer;

    /**
     * 产品/型号
     * model of the bridge. This is also exposed to iOS for unknown purposes.
     */
    private String model;

    /**
     * serial number of the bridge. Also exposed. Purposes also unknown.
     */
    private String serialNumber;

    /**
     * 固件修订
     */
    private String firmwareRevision;

    /**
     * 硬件修订
     */
    private String hardwareRevision;

    /**
     * 是否添加demo
     */
    private boolean addDemo = false;

    /**
     * 自定启动
     */
    private boolean autoStart = true;

    /**
     * 扫描配件包路径
     */
    private String[] baseScanAccessoriesPackagePath;

    /**
     * 开启HomeKit网页控制
     */
    private boolean enableHomeKitWebSite = true;


}
