/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.core.accessories;

import io.github.hapjava.accessories.LightbulbAccessory;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithColorTemperature;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithHardwareRevision;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoLightAccessory
implements LightbulbAccessory,
AccessoryWithHardwareRevision,
AccessoryWithColorTemperature {
    private static final Logger log = LoggerFactory.getLogger(DemoLightAccessory.class);
    private boolean powerState = false;
    private int colorTemperature;
    private HomekitCharacteristicChangeCallback subscribeCallback = null;
    private HomekitCharacteristicChangeCallback colorTemperatureCallback = null;

    public DemoLightAccessory() {
        new Thread(() -> {
            while (true) {
                this.setLightbulbPowerState(new Random().nextInt(2) == 1);
                this.setColorTemperature(new Random().nextInt(100));
                try {
                    TimeUnit.SECONDS.sleep(5L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }).start();
    }

    public int getId() {
        return 0x7FFFFFFE;
    }

    public CompletableFuture<String> getName() {
        return CompletableFuture.completedFuture("Test Switch Name");
    }

    public void identify() {
        log.info("Identifying light");
    }

    public CompletableFuture<String> getSerialNumber() {
        return CompletableFuture.completedFuture("Test SwitchSN");
    }

    public CompletableFuture<String> getModel() {
        return CompletableFuture.completedFuture("TestSwitch Model");
    }

    public CompletableFuture<String> getManufacturer() {
        return CompletableFuture.completedFuture("Test SwitchManufacturer");
    }

    public CompletableFuture<String> getFirmwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Firmware");
    }

    public CompletableFuture<Boolean> getLightbulbPowerState() {
        return CompletableFuture.completedFuture(this.powerState);
    }

    public CompletableFuture<Void> setLightbulbPowerState(boolean powerState) {
        this.powerState = powerState;
        if (this.subscribeCallback != null) {
            this.subscribeCallback.changed();
        }
        log.info("The lightbulb is now " + (powerState ? "on" : "off"));
        return CompletableFuture.completedFuture(null);
    }

    public void subscribeLightbulbPowerState(HomekitCharacteristicChangeCallback callback) {
        this.subscribeCallback = callback;
    }

    public void unsubscribeLightbulbPowerState() {
        this.subscribeCallback = null;
    }

    public CompletableFuture<String> getHardwareRevision() {
        return CompletableFuture.completedFuture("Test Switch Hardware");
    }

    public CompletableFuture<Integer> getColorTemperature() {
        return CompletableFuture.completedFuture(this.colorTemperature);
    }

    public CompletableFuture<Void> setColorTemperature(Integer value) {
        this.colorTemperature = value;
        if (this.colorTemperatureCallback != null) {
            this.colorTemperatureCallback.changed();
        }
        return CompletableFuture.completedFuture(null);
    }

    public void subscribeColorTemperature(HomekitCharacteristicChangeCallback callback) {
        this.colorTemperatureCallback = callback;
    }

    public void unsubscribeColorTemperature() {
        this.colorTemperatureCallback = null;
    }
}

