/*
 * Decompiled with CFR 0.152.
 */
package cn.ximcloud.homekit.core.starter.auth;

import cn.ximcloud.homekit.core.starter.entity.HomeKitAuthInfoEntity;
import cn.ximcloud.homekit.core.starter.entity.HomeKitUserEntity;
import cn.ximcloud.homekit.core.starter.repository.HomeKitAuthInfoRepository;
import cn.ximcloud.homekit.core.starter.repository.HomeKitUserRepository;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitServer;
import io.github.hapjava.server.impl.HomekitUtils;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseOnDataBaseHomeKitAuthInfo
implements HomekitAuthInfo {
    private static final Logger log = LoggerFactory.getLogger(BaseOnDataBaseHomeKitAuthInfo.class);
    private final HomeKitUserRepository homeKitUserRepository;
    private final HomeKitAuthInfoEntity homeKitAuthInfoEntity;

    public BaseOnDataBaseHomeKitAuthInfo(HomeKitAuthInfoRepository homeKitAuthInfoRepository, HomeKitUserRepository homeKitUserRepository) {
        this.homeKitUserRepository = homeKitUserRepository;
        Optional homeKitAuthInfoEntity = homeKitAuthInfoRepository.findById(1);
        HomeKitAuthInfoEntity homeKitAuthInfo = homeKitAuthInfoEntity.orElseGet(() -> {
            try {
                return new HomeKitAuthInfoEntity(HomekitServer.generatePin(), HomekitServer.generateMac(), HomekitServer.generateSalt(), HomekitUtils.generateKey());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException("generate HomeKitAuthInfo error", e);
            }
        });
        homeKitAuthInfoRepository.update(homeKitAuthInfo);
        this.homeKitAuthInfoEntity = homeKitAuthInfo;
        log.info("The PIN for pairing is {}", (Object)homeKitAuthInfo.getPin());
    }

    public String getPin() {
        return this.homeKitAuthInfoEntity.getPin();
    }

    public String getMac() {
        return this.homeKitAuthInfoEntity.getMac();
    }

    public BigInteger getSalt() {
        return this.homeKitAuthInfoEntity.getSalt();
    }

    public byte[] getPrivateKey() {
        return this.homeKitAuthInfoEntity.getPrivateKey();
    }

    public void createUser(String username, byte[] publicKey) {
        Optional<HomeKitUserEntity> homeKitUser = this.homeKitUserRepository.findByUserName(username);
        if (!homeKitUser.isPresent()) {
            this.homeKitUserRepository.save(new HomeKitUserEntity(username, publicKey));
            log.info("Added user for {}", (Object)username);
        } else {
            log.warn("Already have an user for {}", (Object)username);
        }
    }

    public void removeUser(String username) {
        Optional<HomeKitUserEntity> homeKitUser = this.homeKitUserRepository.findByUserName(username);
        if (homeKitUser.isPresent()) {
            log.info("Removed user for {}", (Object)username);
            this.homeKitUserRepository.delete(homeKitUser.get());
        } else {
            log.warn("the user {} not found", (Object)username);
        }
    }

    public byte[] getUserPublicKey(String username) {
        Optional<HomeKitUserEntity> homeKitUser = this.homeKitUserRepository.findByUserName(username);
        if (homeKitUser.isPresent()) {
            return homeKitUser.get().getPublicKey();
        }
        log.warn("the user {} not found", (Object)username);
        return null;
    }

    public boolean hasUser() {
        return this.homeKitUserRepository.count() > 0L;
    }

    public BaseOnDataBaseHomeKitAuthInfo(HomeKitUserRepository homeKitUserRepository, HomeKitAuthInfoEntity homeKitAuthInfoEntity) {
        this.homeKitUserRepository = homeKitUserRepository;
        this.homeKitAuthInfoEntity = homeKitAuthInfoEntity;
    }
}

