package cn.xiaocuoben.chains.fetcher.proxy;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * @author Frank
 * @version 2017/7/30
 */
@Slf4j
public class ChainsProxySelector extends ProxySelector {
    private final static ThreadLocal<ProxyInfo> CURRENT_PROXY_INFO = new ThreadLocal<>();
    @Setter
    @Getter
    private List<ProxyInfo> proxyList = new ArrayList<>();

    public static void resetProxyInfo() {
        ProxyInfo proxyInfo = CURRENT_PROXY_INFO.get();
        if (proxyInfo != null) {
            proxyInfo.setOutOfUse();
        } else {
            log.debug("reset null proxy");
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        Optional<ProxyInfo> firstProxy = proxyList.stream()
                .filter(ProxyInfo::notInUse)
                .findFirst();
        ProxyInfo proxyInfo = firstProxy
                .orElse(null);
        if (firstProxy.isPresent()) {
            Proxy proxy = proxyInfo
                    .setInUseTrue()
                    .getProxy();
            CURRENT_PROXY_INFO.set(proxyInfo);
            log.debug("url {} use proxy {}", uri, proxy);
            return Collections.singletonList(proxy);
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        log.error(ioe.getMessage(), ioe);
    }

    public ProxyInfo addProxyInfo(ProxyInfo proxyInfo) {
        this.proxyList.add(proxyInfo);
        return proxyInfo;
    }
}
