package cn.xiaocuoben.chains.fetcher;

import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;

import java.io.IOException;

@Data
@Setter
@Getter
@NoArgsConstructor
public class RequestWrapper {
    public static final String DEFAULT_METHOD = "GET";

    private String url;
    private String method = DEFAULT_METHOD;
    private Headers headers;
    private RequestBody requestBody;
    private Object tag;

    public RequestWrapper(String url, String method, Headers headers, RequestBody requestBody, Object tag) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.requestBody = requestBody;
        this.tag = tag;
    }

    private RequestWrapper(String url) {
        this.url = url;
    }

    public Request toRequest() {
        Request.Builder requestBuilder = new Request.Builder();
        if (DEFAULT_METHOD.equals(this.method)) {
            requestBuilder.get();
        } else {
            requestBuilder.method(this.method, requestBody);
        }
        if (this.headers != null) {
            requestBuilder.headers(this.headers);
        }
        requestBuilder
                .url(this.url)
                .tag(this.tag);
        return requestBuilder.build();
    }

    public static RequestWrapper newWrapper(Request request) throws IOException {
        return new RequestWrapper(request.url().toString(), request.method(), request.headers(), request.body(), request.tag());
    }

    public static RequestWrapper newWrapper(String url, String method, Headers headers, RequestBody requestBody, Object tag) {
        return new RequestWrapper(url, method, headers, requestBody, tag);
    }

    public static RequestWrapper newWrapper(String url, String method, Headers headers, RequestBody requestBody) throws IOException {
        return new RequestWrapper(url, method, headers, requestBody, null);
    }

    public static RequestWrapper newWrapper(String url, String method, RequestBody requestBody) throws IOException {
        return new RequestWrapper(url, method, null, requestBody, null);
    }

    public static RequestWrapper buildGet(String url, RequestBody requestBody) throws IOException {
        return new RequestWrapper(url, DEFAULT_METHOD, null, requestBody, null);
    }

    public static RequestWrapper buildPost(String url, RequestBody requestBody) {
        return new RequestWrapper(url, "POST", null, requestBody, null);
    }

    public static RequestWrapper newWrapper(String url) {
        return new RequestWrapper(url);
    }
}
