package cn.xiaocuoben.chains.fetcher;

import cn.xiaocuoben.chains.exception.ChainsException;
import cn.xiaocuoben.chains.fetcher.interceptor.ProxyClearInterceptor;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Response;

import java.io.IOException;
import java.net.ProxySelector;

/**
 * @author Frank
 * @version 2017/7/19
 */
@Slf4j
public class OkHttpFetcher implements Fetcher {
    private OkHttpClient okHttpClient;

    public OkHttpFetcher(OkHttpClient.Builder okHttpClientBuilder, ProxySelector proxySelector) {
        if (proxySelector != null) {
            okHttpClientBuilder.proxySelector(proxySelector);
            okHttpClientBuilder.addInterceptor(new ProxyClearInterceptor());
        }
        okHttpClient = okHttpClientBuilder.build();
    }

    @Override
    public Response fetch(RequestWrapper request) {
        long startTime = System.currentTimeMillis();
        try {
            Response resp = okHttpClient.newCall(request.toRequest()).execute();
            if (log.isDebugEnabled()) {
                log.debug("use {} millisecond.fetch {} [{}]", (System.currentTimeMillis() - startTime), request, resp.code());
            }
            return resp;
        } catch (IOException e) {
            log.error("fetch error request:{},error:{}", request, e);
            throw new ChainsException(e);
        }
    }
}
