package cn.xiaocuoben.chains.factory;

import cn.xiaocuoben.chains.config.ChainsConfig;
import cn.xiaocuoben.chains.fetcher.Fetcher;
import cn.xiaocuoben.chains.fetcher.OkHttpFetcher;
import cn.xiaocuoben.chains.fetcher.cookie.HashMapCookieJar;
import cn.xiaocuoben.chains.fetcher.interceptor.LogInterceptor;
import okhttp3.OkHttpClient;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class DefaultChainFactory extends ChainsFactory {
    protected ChainsConfig chainsConfig = new ChainsConfig();

    public DefaultChainFactory(ChainsConfig chainsConfig) {
        this.chainsConfig = chainsConfig;
    }

    public Fetcher createFetcher() {
        return new OkHttpFetcher(new OkHttpClient.Builder()
                .cookieJar(new HashMapCookieJar())
                .addInterceptor(new LogInterceptor()), null);
    }

    public ScheduledExecutorService createMainThreadPool() {
        return Executors.newScheduledThreadPool(this.chainsConfig.getMainThreadPoolSize());
    }
}
