package cn.xiaocuoben.chains.exception.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Frank
 */
public class ExceptionHandlerManager {
    private static final Map<Class<? extends Exception>, ExceptionHandler> EXCEPTION_EXCEPTION_HANDLER_MAP = new ConcurrentHashMap<>();

    static {
        EXCEPTION_EXCEPTION_HANDLER_MAP.put(Exception.class, new DefaultExceptionHandler());
    }

    @SuppressWarnings("all")
    public static ExceptionHandler get(Class<?> exClass) {
        ExceptionHandler handler = EXCEPTION_EXCEPTION_HANDLER_MAP.get(exClass);
        while (handler == null && exClass.getSuperclass() != null) {
            handler = EXCEPTION_EXCEPTION_HANDLER_MAP.get(exClass);
            exClass = exClass.getSuperclass();
        }
        return handler;
    }

    public static void add(Class<? extends Exception> exClass, ExceptionHandler exceptionHandler) {
        EXCEPTION_EXCEPTION_HANDLER_MAP.put(exClass, exceptionHandler);
    }
}
