package cn.xiaocuoben.chains.chain;

import cn.xiaocuoben.chains.utils.Reflections;
import cn.xiaocuoben.chains.utils.TaskIdWorker;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class ChainNodeWrapper {
    @Setter(AccessLevel.PRIVATE)
    @Getter
    private ChainNode chainNode;

    public static ChainNodeWrapper create(RunnableChainNode runnableChainNode, String targetHtml) {
        ChainNode chainNode = new ChainNode(runnableChainNode, targetHtml);
        chainNode.setTaskId(String.valueOf(TaskIdWorker.generateId()));
        ChainNodeWrapper chainNodeWrapper = new ChainNodeWrapper();
        chainNodeWrapper.setChainNode(chainNode);
        return chainNodeWrapper;
    }

    public static ChainNodeWrapper create(Class<? extends RunnableChainNode> chainNodeClass, String targetHtml) {
        RunnableChainNode runnableChainNode = Reflections.newInstance(chainNodeClass);
        return create(runnableChainNode, targetHtml);
    }

}
