package cn.xiaocuoben.chains.chain;

import cn.xiaocuoben.chains.Chains;
import cn.xiaocuoben.chains.fetcher.HttpTag;
import cn.xiaocuoben.chains.fetcher.RequestWrapper;
import cn.xiaocuoben.chains.utils.NodeIdWorker;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Response;

import java.io.IOException;
import java.util.List;

/**
 * @author Frank
 */
@Slf4j
@Getter
@NoArgsConstructor
public final class ChainNode {
    /**
     * 任务ID
     */
    @Setter(AccessLevel.PACKAGE)
    private String taskId;
    /**
     * 节点ID
     */
    @Setter(AccessLevel.PACKAGE)
    private String nodeId;

    private RunnableChainNode runnableChainNode;
    /**
     * 上一步的请求返回
     */
    private Response prevResponse;
    /**
     * 上一步过滤好的文本
     */
    private String targetHtml;

    public ChainNode(RunnableChainNode runnableChainNode, String targetHtml) {
        this.runnableChainNode = runnableChainNode;
        this.targetHtml = targetHtml;
    }

    public List<ChainNodeWrapper> run(ChainContext chainContext) throws IOException {
        RequestWrapper requestWrapper = this.runnableChainNode.request(this.targetHtml, this.prevResponse, chainContext);
        HttpTag httpTag = new HttpTag();
        httpTag.setTaskId(this.taskId);
        httpTag.setNodeId(String.valueOf(NodeIdWorker.generateId()));
        requestWrapper.setTag(httpTag);
        Response response = Chains.current().fetcher().fetch(requestWrapper);
        List<ChainNodeWrapper> chainNodeWrappers = this.runnableChainNode.next(response.body().string(), response, chainContext);
        if (chainNodeWrappers != null && !chainNodeWrappers.isEmpty()) {
            //向下传递response
            chainNodeWrappers.parallelStream()
                    .forEach(chainNodeWrapper -> {
                        chainNodeWrapper.getChainNode().prevResponse = response;
                    });
        }
        return chainNodeWrappers;
    }

    public Integer awaitMillis() {
        return 0;
    }

}
