package cn.xiaocuoben.chains.chain;

import lombok.Data;
import lombok.Getter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/**
 * @author Frank
 * @version 2017/7/22
 */
@Data
public class ChainContext {
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock readLock = readWriteLock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock = readWriteLock.writeLock();

    private volatile String baseURL;
    @Getter
    private Map<String, Object> variables = new ConcurrentHashMap<>();

    private static final ThreadLocal<Map<Object, Object>> THREAD_LOCAL_VARIABLES = new ThreadLocal<>();

    public String getBasePath() {
        return this.baseURL;
    }

    public void setBaseURLIfNull(String baseURL) {
        this.writeLock.lock();
        try {
            if (this.baseURL == null) {
                this.baseURL = baseURL;
            }
        } finally {
            this.writeLock.unlock();
        }
    }

    public void addLocalVariable(Object key, Object value) {
        Map<Object, Object> objectObjectMap = THREAD_LOCAL_VARIABLES.get();
        if (objectObjectMap == null) {
            objectObjectMap = new ConcurrentHashMap<>();
        }
        objectObjectMap.put(key, value);
    }

    public <T> T getLocalVariable(Object key) {
        Map<Object, Object> objectObjectMap = THREAD_LOCAL_VARIABLES.get();
        return (T) objectObjectMap.get(key);
    }


}
