package cn.xiaocuoben.chains.chain;

import cn.xiaocuoben.chains.utils.Strings;
import cn.xiaocuoben.chains.utils.TaskIdWorker;
import lombok.Getter;
import lombok.Setter;

import java.util.concurrent.TimeUnit;

/**
 * @author Frank
 */
public class Chain {
    @Getter
    private final String taskId = String.valueOf(TaskIdWorker.generateId());
    @Setter
    @Getter
    protected ChainNode rootChainNode;
    @Getter
    private long initialDelay;
    @Getter
    private long period;
    @Getter
    private TimeUnit unit;

    protected Chain(RunnableChainNode runnableChainNode, String targetHtml) {
        this.rootChainNode = new ChainNode(runnableChainNode, targetHtml);
    }

    protected Chain(RunnableChainNode runnableChainNode) {
        this.rootChainNode = new ChainNode(runnableChainNode, Strings.EMPTY);
    }

    protected Chain(RunnableChainNode runnableChainNode, long initialDelay, long period, TimeUnit unit) {
        this(runnableChainNode);
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
    }

    protected Chain(RunnableChainNode runnableChainNode, long period, TimeUnit unit) {
        this(runnableChainNode);
        this.initialDelay = 0L;
        this.period = period;
        this.unit = unit;
    }

    public static Chain create(RunnableChainNode runnableChainNode, long initialDelay, long period, TimeUnit unit) {
        return new Chain(runnableChainNode, initialDelay, period, unit);
    }

    public static Chain create(RunnableChainNode runnableChainNode, long period, TimeUnit unit) {
        return new Chain(runnableChainNode, 0, period, unit);
    }

    public static Chain create(RunnableChainNode runnableChainNode) {
        return new Chain(runnableChainNode, Strings.EMPTY);
    }
}
