package cn.xiaocuoben.chains.task.store.impl;

import cn.xiaocuoben.chains.chain.ChainNode;
import cn.xiaocuoben.chains.config.ChainsConfig;
import cn.xiaocuoben.chains.task.store.ChainNodeStore;
import cn.xiaocuoben.chains.utils.JSONs;
import cn.xiaocuoben.chains.utils.Reflections;
import lombok.Getter;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Frank
 * @version 2017/8/3
 */
@Slf4j
public class MapDBChainNodeStore implements ChainNodeStore {
    private DB db;
    /**
     * MapDB存储的任务列表list名
     */
    @Getter
    private String listName = "taskList";

    public MapDBChainNodeStore(DB db) {
        this.db = db;
    }

    public static ChainNodeStore create(ChainsConfig chainsConfig) {
        DB db = DBMaker.fileDB(chainsConfig.getChainNodeStoreFileName())
                .fileLockWait(1000)
                .closeOnJvmShutdown()
                .checksumHeaderBypass()
                .transactionEnable()
                .make();
        return new MapDBChainNodeStore(db);
    }

    @Override
    public void store(ChainNode chainNode) {
        String           chainNodeStr     = JSONs.write(chainNode);
        ChainNodeWrapper chainNodeWrapper = new ChainNodeWrapper();
        chainNodeWrapper.setClassName(chainNode.getClass().getName());
        chainNodeWrapper.setContent(chainNodeStr);
        chainNodeWrapper.setNodeId(chainNode.getNodeId());

        this.createOrOpen().put(chainNode.getNodeId(), JSONs.write(chainNodeWrapper));
        log.debug("store {}", chainNodeStr);
    }

    @Override
    public List<ChainNode> readAll() {
        List<ChainNode>          chainNodeList    = new ArrayList<>();
        HTreeMap<String, String> typeChainNodeMap = this.createOrOpen();
        for (String nodeId : typeChainNodeMap.getKeys()) {
            String chainNodeWrapperStr = typeChainNodeMap.get(nodeId);

            ChainNodeWrapper chainNodeWrapper = JSONs.read(chainNodeWrapperStr, ChainNodeWrapper.class);
            Object           chainNode        = JSONs.read(chainNodeWrapper.getContent(), Reflections.load(chainNodeWrapper.getClassName()));
            log.debug("recovery task {}", chainNode);
            chainNodeList.add((ChainNode) chainNode);
        }
        return chainNodeList;
    }

    @Override
    public void remove(@NonNull ChainNode chainNode) {
        this.createOrOpen().remove(chainNode.getNodeId());
        log.debug("remove {}", chainNode.getNodeId());
    }

    @Override
    public void remove(String nodeId) {
        this.createOrOpen().remove(nodeId);
        log.debug("remove {}", nodeId);
    }

    private HTreeMap<String, String> createOrOpen() {
        return db.hashMap(this.listName)
                .keySerializer(Serializer.STRING)
                .valueSerializer(Serializer.STRING)
                .createOrOpen();
    }
}
