package cn.xiaocuoben.chains.selector;

import cn.xiaocuoben.chains.utils.Strings;
import org.jsoup.Jsoup;
import us.codecraft.xsoup.Xsoup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @author Frank
 */
public class Selectors {
    /**
     * 分隔符
     */
    private static final String SPLIT_CHAR = "\n";
    /**
     * 洋葱芯
     */
    private String onion;

    public static Selectors buildParser(String onion) {
        Selectors selectors = new Selectors();
        selectors.onion = onion;
        return selectors;
    }

    public Selectors cssSelector(String cssSelector) {
        this.onion = Jsoup.parse(this.onion).select(cssSelector).outerHtml();
        return this;
    }

    public Selectors cssSelector(Select select) {
        this.onion = select.select(Jsoup.parse(this.onion));
        return this;
    }

    public Selectors xpath(String xpath) {
        this.onion = String.join(Selectors.SPLIT_CHAR, Xsoup.select(this.onion, xpath).list());
        return this;
    }

    public Selectors regex(String regex) {
        return this.regex(regex, 0);
    }

    public Selectors regex(String regex, int group) {
        Pattern       pattern      = Pattern.compile(regex);
        Matcher       matcher      = pattern.matcher(this.onion);
        StringBuilder onionBuilder = new StringBuilder();
        while (matcher.find()) {
            onionBuilder.append(matcher.group(group)).append(Selectors.SPLIT_CHAR);
        }
        this.onion = onionBuilder.toString();
        return this;
    }

    public String get() {
        return this.onion;
    }

    public List<String> list() {
        return Splitor.split(this.onion);
    }

    public <T> List<T> list(Function<String, T> mapper) {
        return this.list()
                .stream()
                .map(mapper)
                .collect(Collectors.toList());
    }

    public List<String> listLink(String baseURL) {
        return this.listLink(baseURL, s -> s);
    }

    public <T> List<T> listLink(String baseURL, Function<String, T> mapper) {
        if (baseURL == null) {
            return new ArrayList<>();
        }
        this.link();
        if (Strings.isEmpty(this.onion)) {
            return new ArrayList<>();
        }
        return this.list().stream()
                .map(link -> Strings.concatURL(baseURL, link))
                .map(mapper)
                .collect(Collectors.toList());
    }

    public List<String> link() {
        this.regex("href=\"(.*?)\"", 1);
        return this.list();
    }

    public String text() {
        return Jsoup.parse(this.onion).text();
    }

    public String html() {
        return this.onion;
    }

    public <T> T text(Function<String, T> mapper) {
        return mapper.apply(this.text());
    }

    public String last() {
        List<String> htmlList = this.list();
        return htmlList.get(htmlList.size() - 1);
    }

    public String lastLink(String baseURL) {
        List<String> linkList = this.listLink(baseURL);
        if (linkList != null && !linkList.isEmpty()) {
            return linkList.get(linkList.size() - 1);
        }
        return Strings.EMPTY;
    }

    public <T> T last(Function<String, T> mapper) {
        return mapper.apply(this.last());
    }

    public static class Splitor {
        private Splitor() {
        }

        static List<String> split(String content) {
            return Arrays.stream(content.split(Selectors.SPLIT_CHAR))
                    .collect(Collectors.toList());
        }
    }
}
