package cn.xiaocuoben.chains.fetcher.proxy;

import lombok.Getter;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author Frank
 * @version 2017/7/30
 */
public class ProxyInfo {
    @Getter
    private Proxy proxy;
    /**
     * 使用中
     */
    private AtomicBoolean inUse = new AtomicBoolean(Boolean.FALSE);

    public ProxyInfo(Proxy.Type proxyType, String proxyHost, Integer proxyPort) {
        this.proxy = new Proxy(proxyType, new InetSocketAddress(proxyHost, proxyPort));
    }

    public ProxyInfo(String proxyType, String proxyHost, Integer proxyPort) {
        this(Proxy.Type.valueOf(proxyType), proxyHost, proxyPort);
    }

    public boolean isInUse() {
        return this.inUse.get();
    }

    public boolean notInUse() {
        return !this.isInUse();
    }

    public ProxyInfo setInUseTrue() {
        this.inUse.set(Boolean.TRUE);
        return this;
    }

    public ProxyInfo setOutOfUse() {
        this.inUse.set(Boolean.FALSE);
        return this;
    }
}
