package cn.xiaocuoben.chains.fetcher.interceptor;

import cn.xiaocuoben.chains.fetcher.proxy.ChainsProxySelector;
import okhttp3.Response;

import java.io.IOException;

/**
 * @author Frank
 * @version 2017/7/30
 */
public class ProxyClearInterceptor implements okhttp3.Interceptor {

    @Override
    public Response intercept(Chain chain) throws IOException {
        Response          response  = chain.proceed(chain.request());
        okhttp3.MediaType mediaType = response.body().contentType();
        String            content   = response.body().string();
        //重置
        ChainsProxySelector.resetProxyInfo();
        return response.newBuilder()
                .body(okhttp3.ResponseBody.create(mediaType, content))
                .build();
    }
}
