package cn.xiaocuoben.chains.utils;

import cn.xiaocuoben.chains.exception.ChainsException;
import lombok.extern.slf4j.Slf4j;

/**
 * @author Frank
 * @version 2017/7/23
 */
@Slf4j
public class IdWorker {
    private static final long WORKER_ID_BITS       = 10L;
    private static final long MAX_WORKER_ID        = 1023L;
    private static final long SEQUENCE_BITS        = 12L;
    private static final long WORKER_ID_SHIFT      = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK        = 4095L;
    private              long workerId             = -1L;
    private              long epoch                = 1494929004000L;
    private              long sequence             = 0L;
    private              long lastTimestamp        = -1L;

    public IdWorker(long workerId, long epoch) {
        this.epoch = epoch;
        this.workerId = workerId;
        this.validate(workerId);
        if (log.isDebugEnabled()) {
            log.debug("IdWorker [init] workerId={} epoch={}", workerId, epoch);
        }

    }

    private IdWorker() {
    }

    private void validate(long workerId) {
        if (workerId > 1023L || workerId < 0L) {
            throw new IllegalArgumentException("workerId must between 0 end 1023");
        }
    }

    private synchronized long nextId() {
        long timestamp = this.timeGen();
        this.sequence = this.sequence + 1L & 4095L;
        if (this.lastTimestamp == timestamp) {
            if (log.isDebugEnabled()) {
                log.debug("last timestamp [{}]", this.lastTimestamp);
            }

            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        }

        if (log.isDebugEnabled()) {
            log.debug("sequence [{}]", this.sequence);
        }

        if (timestamp < this.lastTimestamp) {
            throw new ChainsException(String.format("System Clock Error. last timestamp is [%s]", this.lastTimestamp));
        } else {
            this.lastTimestamp = timestamp;
            return timestamp - this.epoch << 22 | this.workerId << 12 | this.sequence;
        }
    }

    private long tilNextMillis(long lastTimestamp) {
        if (log.isDebugEnabled()) {
            log.debug("last timestamp is [{}] ", lastTimestamp);
        }

        long timestamp;
        for (timestamp = this.timeGen(); timestamp <= lastTimestamp; timestamp = this.timeGen()) {
            ;
        }

        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public long generateId() {
        return this.nextId();
    }
}
