package cn.xiaocuoben.chains.factory;

import cn.xiaocuoben.chains.chain.ChainNodeExecutor;
import cn.xiaocuoben.chains.config.ChainsConfig;
import cn.xiaocuoben.chains.fetcher.Fetcher;
import cn.xiaocuoben.chains.fetcher.OkHttpFetcher;
import cn.xiaocuoben.chains.fetcher.interceptor.LogInterceptor;
import cn.xiaocuoben.chains.task.store.ChainNodeStore;
import cn.xiaocuoben.chains.task.store.impl.MapDBChainNodeStore;
import okhttp3.OkHttpClient;

import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;

/**
 * @author Frank
 */
public class ChainsFactory {
    protected ChainsConfig chainsConfig = new ChainsConfig();

    public ChainsFactory(ChainsConfig chainsConfig) {
        this.chainsConfig = chainsConfig;
    }

    public ChainNodeExecutor createChainNodeExecutor() {
        ForkJoinPool taskPool = new ForkJoinPool(this.chainsConfig.getThreadPoolSize());
        return new ChainNodeExecutor(taskPool);
    }

    public Fetcher createFetcher() {
        return new OkHttpFetcher(new OkHttpClient.Builder()
                .addInterceptor(new LogInterceptor()), null);
    }

    public ChainNodeStore createChainNodeStore() {
        return MapDBChainNodeStore.create(this.chainsConfig);
    }

    public ScheduledExecutorService createMainThreadPool() {
        return Executors.newScheduledThreadPool(this.chainsConfig.getMainThreadPoolSize());
    }
}
