package cn.xiaocuoben.chains.config;

import lombok.Data;

/**
 * @author Frank
 */
@Data
public class ChainsConfig {
    /**
     * 默认线程池容量
     */
    public static final int DEFAULT_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 3;

    /**
     * 主线程池最大容量
     */
    private int threadPoolSize = DEFAULT_POOL_SIZE;

    private int    mainThreadPoolSize     = DEFAULT_POOL_SIZE;
    /**
     * 任务存储器的文件目录
     */
    private String chainNodeStoreFileName = System.getProperty("user.dir") + "/tmp" + "/task.db";
}
