package cn.xiaocuoben.chains.chain;


import cn.xiaocuoben.chains.Chains;
import cn.xiaocuoben.chains.exception.ChainsException;
import cn.xiaocuoben.chains.utils.NodeIdWorker;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;

/**
 * @author Frank
 */
@Slf4j
public class ChainExecute implements Runnable {
    private static final ChainContext CHAIN_CONTEXT = new ChainContext();
    private Chain chain;
    private ChainNodeExecutor chainNodeExecutor = Chains.current().chainNodeExecutor();

    public ChainExecute(Chain chain) {
        this.chain = chain;
    }

    @Override
    public void run() {
        List<ChainNode> nextChainNodeList = Collections.singletonList(this.chain.getRootChainNode());
        try {
            LocalDateTime startTime = LocalDateTime.now();
            while (nextChainNodeList != null && !nextChainNodeList.isEmpty()) {
                for (ChainNode node : nextChainNodeList) {
                    node.setTaskId(this.chain.getTaskId());
                    node.setNodeId(String.valueOf(NodeIdWorker.generateId()));
                }
                ChainNodeTask   chainNodeTask  = this.chainNodeExecutor.submit(nextChainNodeList, CHAIN_CONTEXT);//可能触发拒绝任务
                List<ChainNode> nodeReturnList = chainNodeTask.get();
                // chainNodeTask.isCompletedNormally(); chainNodeTask.isCompletedAbnormally(); 都返回了null .....
                if (chainNodeTask.getException() != null) {
                    throw chainNodeTask.getException();
                }
                nextChainNodeList = nodeReturnList;
            }
            long consumedMillis = ChronoUnit.MILLIS.between(startTime, LocalDateTime.now());
            log.info("[{}] end. Consumed {} milliseconds", this.chain, consumedMillis);
        } catch (Throwable e) {
            throw new ChainsException(e);
        }
    }
}
