package cn.xiaocuoben.chains.utils;

import cn.xiaocuoben.chains.exception.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.NonNull;

import java.io.IOException;

/**
 * @author Frank
 * @version 2017/8/6
 */
public class JSONs {
    private JSONs(){}

    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T read(@NonNull String content, Class<T> clazz){
        try {
            return OBJECT_MAPPER.readValue(content,clazz);
        } catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public static String write(@NonNull Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        } catch (JsonProcessingException e) {
            throw new JSONException(e);
        }
    }
}
