package cn.xiaocuoben.chains.task;

import cn.xiaocuoben.chains.exception.ChainsException;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/**
 * @author Frank
 */
@Slf4j
public class ChainsTaskExecutor {
    @Getter
    private ForkJoinPool threadPool;

    private volatile List<ChainsTask> chainsTaskList = new ArrayList<>();

    private ReentrantLock reentrantLock = new ReentrantLock();

    public ChainsTaskExecutor(ForkJoinPool threadPool) {
        this.threadPool = threadPool;
    }

    public void submit(ChainsTask chainsTask) {
        this.reentrantLock.lock();
        try {
            this.threadPool.submit(chainsTask);
            this.chainsTaskList.add(chainsTask);
        } finally {
            this.reentrantLock.unlock();
        }
    }

    public void awaitShutdown() {
        try {
            while(!this.chainsTaskList.isEmpty()){
                TimeUnit.SECONDS.sleep(1);
                this.chainsTaskList.removeIf(ChainsTask::isEnd);
            }
            this.threadPool.shutdown();
        } catch (InterruptedException e) {
            throw new ChainsException(e);
        }
    }
}
