package cn.xiaocuoben.chains.task;

import cn.xiaocuoben.chains.chain.Chain;
import cn.xiaocuoben.chains.chain.ChainNode;
import cn.xiaocuoben.chains.exception.handler.ExceptionHandler;
import cn.xiaocuoben.chains.exception.handler.ExceptionHandlerManager;
import cn.xiaocuoben.chains.task.store.ChainNodeStore;
import cn.xiaocuoben.chains.utils.TaskIdWorker;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.ForkJoinPool;

/**
 * @author Frank
 */
@Data
@Slf4j
@EqualsAndHashCode(callSuper = false)
public class ChainsTask implements Runnable {
    private String   taskId   = null;
    private Chain    chain    = null;
    /**
     * 任务是否执行结束
     */
    private boolean isEnd = false;

    public static ChainsTask create(ForkJoinPool chainNodeTaskExecutor, ChainNodeStore chainNodeStore, ChainNode chainNode) {
        ChainsTask chainsTask = new ChainsTask();
        chainsTask.taskId = String.valueOf(TaskIdWorker.generateId());

        Chain cn = new Chain(chainsTask.taskId,chainNode, chainNodeTaskExecutor,chainNodeStore);
        chainsTask.setChain(cn);
        return chainsTask;
    }

    @Override
    @SuppressWarnings("all")
    public void run() {
        try {
            this.chain.execute();
            this.isEnd = true;
        } catch (Exception e) {
            ExceptionHandler handler = ExceptionHandlerManager.get(e.getClass());
            if (handler != null) {
                handler.handle(e);
            } else {
                log.error("[ChainsTask Exception]{}", e);
            }
        }
    }

    public boolean isEnd(){
        return this.isEnd;
    }

}
