package cn.xiaocuoben.chains.fetcher.interceptor;

import cn.xiaocuoben.chains.utils.Strings;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Interceptor;
import okhttp3.Request;

import java.io.IOException;
import java.util.Locale;

/**
 * @author Frank
 * @version 2017/7/23
 */
@Slf4j
public class LogInterceptor implements Interceptor {

    @Override
    public okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        log.debug("request:" + request.toString());
        long t1 = System.nanoTime();
        okhttp3.Response response = chain.proceed(chain.request());
        long t2 = System.nanoTime();
        if(log.isDebugEnabled()){
            log.debug(String.format(Locale.getDefault(), "Received response for %s in %.1fms%n%s",response.request().url(), (t2 - t1) / 1e6d, response.headers()));
        }
        okhttp3.MediaType mediaType = response.body().contentType();
        String content = response.body().string();
        if(log.isTraceEnabled()){
            log.trace("response [{}] {}" ,response.code(),Strings.closeTo(content));
        }
        return response.newBuilder()
                .body(okhttp3.ResponseBody.create(mediaType, content))
                .build();
    }
}
