package cn.xiaocuoben.chains.fetcher;

import cn.xiaocuoben.chains.exception.ChainsException;
import cn.xiaocuoben.chains.fetcher.interceptor.LogInterceptor;
import cn.xiaocuoben.chains.fetcher.interceptor.ProxyClearInterceptor;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;
import java.net.ProxySelector;

/**
 * @author Frank
 * @version 2017/7/19
 */
@Slf4j
public class OkHttpFetcher implements Fetcher {
    private OkHttpClient  okHttpClient;
    private ProxySelector proxySelector;

    public OkHttpFetcher(OkHttpClient.Builder okHttpClientBuilder, ProxySelector proxySelector) {
        if (proxySelector != null) {
            okHttpClientBuilder.proxySelector(proxySelector);
            okHttpClientBuilder.addInterceptor(new ProxyClearInterceptor());
        }
        okHttpClientBuilder.addInterceptor(new LogInterceptor());
        okHttpClient = okHttpClientBuilder.build();
    }

    @Override
    public HtmlInfo fetch(HttpInfo httpInfo) {
        long startTime = System.currentTimeMillis();
        try {
            Request req = new Request.Builder()
                    .url(httpInfo.getLink())
                    .tag(httpInfo.getTaskId())
                    .build();
            Response resp        = okHttpClient.newCall(req).execute();
            String   respContent = resp.body().string();
            if (log.isDebugEnabled()) {
                log.debug("{}-{}-fetch {} [{}] use {} millisecond", httpInfo.getTaskId(), httpInfo.getNodeId(), httpInfo.getLink(), resp.code(), (System.currentTimeMillis() - startTime));
            }
            return new HtmlInfo(respContent, req.url().encodedPath());
        } catch (IOException e) {
            log.error("{}-{}-fetch error url:{},error:{}", httpInfo.getTaskId(), httpInfo.getNodeId(), httpInfo.getLink(), e);
            throw new ChainsException(e);
        }
    }

}
