package cn.xiaocuoben.chains.config;

import cn.xiaocuoben.chains.task.ChainsTaskExecutor;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.util.concurrent.ForkJoinPool;

/**
 * @author Frank
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class ChainsFactory {

    public static ChainsTaskExecutor createChainsTaskExecutor(ChainsConfig chainsConfig) {
        ForkJoinPool mainPool = new ForkJoinPool(chainsConfig.getThreadPoolSize());
        return new ChainsTaskExecutor(mainPool);
    }
}
