package cn.xiaocuoben.chains.chain;

import cn.xiaocuoben.chains.task.store.ChainNodeStore;
import lombok.Getter;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * @author Frank
 * @version 2017/7/22
 */
public class ChainNodeExecutor {
    private ForkJoinPool forkJoinPool;
    @Getter
    private ChainNodeStore chainNodeStore;

    public ChainNodeExecutor(ForkJoinPool forkJoinPool, ChainNodeStore chainNodeStore) {
        this.forkJoinPool = forkJoinPool;
        this.chainNodeStore = chainNodeStore;
    }

    public ChainNodeTask submit(ChainNode chainNode, ChainContext chainContext) {
        ChainNodeTask chainNodeTask = new ChainNodeTask(Collections.singletonList(chainNode), chainContext, this, this.createTaskLock(),this.chainNodeStore);
        this.forkJoinPool.submit(chainNodeTask);
        return chainNodeTask;
    }

    public ChainNodeTask submit(List<ChainNode> chainNodeList, ChainContext chainContext) {
        ChainNodeTask chainNodeTask = new ChainNodeTask(chainNodeList, chainContext, this, this.createTaskLock(),this.chainNodeStore);
        this.forkJoinPool.submit(chainNodeTask);
        return chainNodeTask;
    }

    private Lock createTaskLock() {
        return new ReentrantLock();
    }
}
