package cn.xiaocuoben.chains.chain;

import cn.xiaocuoben.chains.Chains;
import cn.xiaocuoben.chains.fetcher.HtmlInfo;
import cn.xiaocuoben.chains.fetcher.HttpInfo;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author Frank
 */
@Slf4j
@Data
@NoArgsConstructor
public abstract class ChainNode {
    /**
     * 任务ID
     */
    @Setter
    @Getter
    private String taskId;
    /**
     * 节点ID
     */
    @Getter
    @Setter
    private String nodeId;

    protected String url;

    public ChainNode(String url) {
        this.url = url;
    }

    private HtmlInfo fetch(HttpInfo httpInfo) {
        httpInfo.setTaskId(this.taskId);
        httpInfo.setNodeId(this.nodeId);
        String link = httpInfo.getLink();
        if (link.startsWith("/")) {
            httpInfo.setLink(httpInfo.getBasePath() + link);
        }
        return Chains.current().getFetcher().fetch(httpInfo);
    }

    protected HttpInfo buildRequest(ChainContext chainContext) {
        return HttpInfo.builder().basePath(chainContext.getBasePath()).link(this.url).build();
    }

    protected abstract List<ChainNode> execute(ChainContext chainContext, HtmlInfo htmlInfo);

    public List<ChainNode> run(ChainContext chainContext) {
        HtmlInfo htmlInfo = this.fetch(this.buildRequest(chainContext));
        return this.execute(chainContext, htmlInfo);
    }

    public Integer awaitMillis() {
        return Chains.current().getChainsConfig().getAwaitMillis();
    }

}
