package cn.xiaocuoben.chains.chain;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/**
 * @author Frank
 * @version 2017/7/22
 */
@Data
public class ChainContext {
    private ReentrantReadWriteLock           readWriteLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock  readLock      = readWriteLock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock     = readWriteLock.writeLock();

    private volatile String baseURL;
    @Getter
    @Setter
    private Map<String, Object> variables = new ConcurrentHashMap<>();

    public String getBasePath(){
        return this.baseURL;
    }

    public void setBaseURLIfNull(String baseURL){
        this.writeLock.lock();
        try{
            if(this.baseURL == null){
                this.baseURL = baseURL;
            }
        }finally {
            this.writeLock.unlock();
        }
    }


}
