package cn.xiaocuoben.chains.chain;


import cn.xiaocuoben.chains.exception.ChainsException;
import cn.xiaocuoben.chains.task.store.ChainNodeStore;
import cn.xiaocuoben.chains.utils.NodeIdWorker;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ForkJoinPool;

/**
 * @author Frank
 */
@Slf4j
public class Chain {
    private static final  ChainContext      CHAIN_CONTEXT     = new ChainContext();

    private String            taskId            = null;
    private ChainNode         rootChainNode     = null;
    private ChainNodeExecutor chainNodeExecutor = null;

    public Chain(String taskId, ChainNode chainNode, ForkJoinPool mainThreadPool,ChainNodeStore chainNodeStore) {
        this.taskId = taskId;
        this.rootChainNode = chainNode;
        this.chainNodeExecutor = new ChainNodeExecutor(mainThreadPool, chainNodeStore);
    }

    public void execute() {
        List<ChainNode> nextChainNodeList = Collections.singletonList(this.rootChainNode);
        try {
            while (nextChainNodeList != null && !nextChainNodeList.isEmpty()) {
                for (ChainNode node : nextChainNodeList) {
                    node.setTaskId(this.taskId);
                    node.setNodeId(String.valueOf(NodeIdWorker.generateId()));
                }
                ChainNodeTask   chainNodeTask  = this.chainNodeExecutor.submit(nextChainNodeList, CHAIN_CONTEXT);//可能触发拒绝任务
                List<ChainNode> nodeReturnList = chainNodeTask.get();
                // chainNodeTask.isCompletedNormally(); chainNodeTask.isCompletedAbnormally(); 都返回了null .....
                if (chainNodeTask.getException() != null) {
                    throw chainNodeTask.getException();
                }

                if (nodeReturnList != null && !nodeReturnList.isEmpty()) {
                    nextChainNodeList = nodeReturnList;
                } else {
                    nextChainNodeList = null;
                    log.info("task [{}] end", rootChainNode);
                }
            }

        } catch (Throwable e) {
            throw new ChainsException(e);
        }
    }
}
