package cn.xiaocuoben.chains;

import cn.xiaocuoben.chains.chain.ChainNode;
import cn.xiaocuoben.chains.config.ChainsConfig;
import cn.xiaocuoben.chains.config.ChainsFactory;
import cn.xiaocuoben.chains.fetcher.OkHttpFetcher;
import cn.xiaocuoben.chains.fetcher.interceptor.LogInterceptor;
import cn.xiaocuoben.chains.task.ChainsTask;
import cn.xiaocuoben.chains.task.ChainsTaskExecutor;
import cn.xiaocuoben.chains.task.store.ChainNodeStore;
import cn.xiaocuoben.chains.task.store.impl.MapDBChainNodeStore;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import okhttp3.OkHttpClient;

import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author Frank
 * @version 2017/7/29
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class Chains {
    private static final  Chains THE_WORLD = new Chains();

    @Setter(AccessLevel.PRIVATE)
    @Getter
    private ChainsConfig chainsConfig = new ChainsConfig();

    @Setter(AccessLevel.PRIVATE)
    private ChainsTaskExecutor chainNodeTaskExecutor;

    private List<ChainNode> firstChainNodeList = new ArrayList<>();

    @Getter
    private OkHttpFetcher fetcher = new OkHttpFetcher(new OkHttpClient.Builder()
            .addInterceptor(new LogInterceptor()),null);


    private ChainNodeStore chainNodeStore = MapDBChainNodeStore.create(this.chainsConfig);

    public static Chains create(){
        return THE_WORLD;
    }
    public static Chains create(ChainsConfig chainsConfig){
        THE_WORLD.setChainsConfig(chainsConfig);
        return THE_WORLD;
    }

    public static Chains current(){
        return THE_WORLD;
    }

    public Chains addAllNode(ChainNode... firstChainNodes){
        this.firstChainNodeList.addAll(Arrays.asList(firstChainNodes));
        return this;
    }

    public Chains fetcher(ProxySelector proxySelector){
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        this.fetcher = new OkHttpFetcher(okHttpClientBuilder,proxySelector);
        return this;
    }

    public Chains chainNodeStore(ChainNodeStore chainNodeStore){
        this.chainNodeStore = chainNodeStore;
        return this;
    }

    public Chains chainNodeStore(){
        this.chainNodeStore = MapDBChainNodeStore.create(this.chainsConfig);
        return this;
    }

    private void beforeStart(){
        this.chainNodeTaskExecutor = ChainsFactory.createChainsTaskExecutor(this.chainsConfig);
        this.firstChainNodeList.addAll(this.chainNodeStore.readAll());
    }

    public void start(){
        this.beforeStart();
        for (ChainNode chainNode : firstChainNodeList) {
            ChainsTask task = ChainsTask.create(this.chainNodeTaskExecutor.getThreadPool(),this.chainNodeStore, chainNode);
            this.chainNodeTaskExecutor.submit(task);
        }
        this.chainNodeTaskExecutor.awaitShutdown();
    }
}
