package me.codeleep.jsondiff.test.simple;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import me.codeleep.jsondiff.common.model.JsonCompareResult;
import me.codeleep.jsondiff.common.model.JsonComparedOption;
import me.codeleep.jsondiff.DefaultJsonDifference;
import me.codeleep.jsondiff.core.config.JsonDiffOption;
import me.codeleep.jsondiff.test.model.GlobalCustomerComparator;
import me.codeleep.jsondiff.test.model.SeparateCustomerComparator;
import org.testng.Assert;
import org.testng.annotations.Test;

/**
 * @author: codeleep
 * @createTime: 2023/10/10 11:02
 * @description:
 */
public class TemporaryTest {


    @Test(description = "2023-10-08 反馈以下例子抛出 【key不允许出现非String类型】。已解决")
    public void  test() {
        String str = "{\"a\":\"a\",\"b\":\"b\",\"c\":[{\"aa\":\"aa\"},{\"bb\":\"bb\"},{\"cc\":\"cc\"}]}";
        String str2 = "{\"b\":\"b\",\"a\":\"a\",\"c\":[{\"bb\":\"bb\"},{\"aa\":\"aa\"},{\"cc\":\"cc\"}]}";

        JsonComparedOption jsonComparedOption = new JsonComparedOption().setIgnoreOrder(true);
        JsonCompareResult jsonCompareResult = new DefaultJsonDifference()
                .option(jsonComparedOption)
                .detectDiff(JSON.parseObject(str), JSON.parseObject(str2));
        System.out.println(JSON.toJSONString(jsonCompareResult));
    }

    @Test
    public void test4() {
        String array1 = "[{\"cooperativeBookTypeId\":2,\"officeName\":\"新增信息\",\"responsibleEditorName\":\"新增责任编辑姓名\",\"id\":71,\"typeQuantity\":\"10\"}]";
        String array2 = "[{\"cooperativeBookTypeId\":2,\"officeName\":\"新增信息\",\"responsibleEditorName\":\"新增责任编辑姓名\",\"id\":71,\"typeQuantity\":\"10\",\"responsiblePersonName\":\"编辑第一次，新增负责人姓名\"}]";

        JsonComparedOption jsonComparedOption = new JsonComparedOption().setIgnoreOrder(true);
        JsonCompareResult jsonCompareResult = new DefaultJsonDifference()
                .option(jsonComparedOption)
                .detectDiff(JSON.parseArray(array1), JSON.parseArray(array2));
        System.out.println(JSON.toJSONString(jsonCompareResult));


        String str1 = "{\"cooperativeBookTypeId\":2,\"officeName\":\"新增信息\",\"responsibleEditorName\":\"新增责任编辑姓名\",\"id\":71,\"typeQuantity\":\"10\"}";
        String str2 = "{\"cooperativeBookTypeId\":2,\"officeName\":\"新增信息\",\"responsibleEditorName\":\"新增责任编辑姓名\",\"id\":71,\"typeQuantity\":\"10\",\"responsiblePersonName\":\"编辑第一次，新增负责人姓名\"}";
        JsonCompareResult jsonCompareResult2 = new DefaultJsonDifference()
                .option(jsonComparedOption)
                .detectDiff(JSONObject.parseObject(str1), JSONObject.parseObject(str2));
        System.out.println(JSONObject.toJSONString(jsonCompareResult2));

    }

    @Test(description = "2024-03-22 新增全局与独立对比属性隔离配置，要求: 1.全局与独立互不影响 2.兼容老版本")
    public void globalOrSeparateComparatorConfigShouldWorked() {
        String str = "{\"a\":\"a\",\"b\":\"b\",\"c\":[{\"aa\":\"aa\"},{\"bb\":\"bb\"},{\"cc\":\"cc\"}]}";
        String str2 = "{\"b\":\"b\",\"a\":\"a\",\"c\":[{\"bb\":\"bb\"},{\"aa\":\"aa\"},{\"cc\":\"cc\"}]}";

        String path = "root.a";

        JsonComparedOption separateJsonComparedOption = new JsonComparedOption()
                .setIgnoreOrder(true)
                .addCustomComparator(path, SeparateCustomerComparator.class);

        JsonCompareResult jsonCompareResult1 = new DefaultJsonDifference().option(separateJsonComparedOption)
                .detectDiff(JSON.parseObject(str), JSON.parseObject(str2));
        System.out.println(JSONObject.toJSONString(jsonCompareResult1));
        Assert.assertTrue(JSONObject.toJSONString(jsonCompareResult1).contains(SeparateCustomerComparator.ILLUSTRATE_MSG));

        JsonComparedOption globalJsonComparedOption = new JsonComparedOption()
                .setIgnoreOrder(true)
                .addCustomComparator(path, GlobalCustomerComparator.class);

        JsonDiffOption.openUniqueOption();
        JsonDiffOption.setGloballyUniqueOption(globalJsonComparedOption);
        JsonCompareResult jsonCompareResult2 = new DefaultJsonDifference()
                .detectDiff(JSON.parseObject(str), JSON.parseObject(str2));
        System.out.println(JSONObject.toJSONString(jsonCompareResult2));
        Assert.assertTrue(JSONObject.toJSONString(jsonCompareResult2).contains(GlobalCustomerComparator.ILLUSTRATE_MSG));

        // 兼容老版本测试
        JsonComparedOption oldVersionJsonComparedOption = new JsonComparedOption()
                .setIgnoreOrder(true);
        JsonDiffOption.getJsonNeatFactory().addCustomComparator(path, SeparateCustomerComparator.class);
        JsonCompareResult jsonCompareResult3 = new DefaultJsonDifference().option(oldVersionJsonComparedOption)
                .detectDiff(JSON.parseObject(str), JSON.parseObject(str2));
        System.out.println(JSONObject.toJSONString(jsonCompareResult3));
        Assert.assertTrue(JSONObject.toJSONString(jsonCompareResult3).contains(SeparateCustomerComparator.ILLUSTRATE_MSG));

    }



}
