package me.codeleep.jsondiff.test.model;

import cn.hutool.core.collection.ListUtil;
import me.codeleep.jsondiff.common.model.Defects;
import me.codeleep.jsondiff.common.model.JsonCompareResult;
import me.codeleep.jsondiff.core.handle.primitive.AbstractPrimitiveJsonNeat;


/**
 * @author Kechen
 */
public class GlobalCustomerComparator extends AbstractPrimitiveJsonNeat {

    public final static String ILLUSTRATE_MSG = "Use global customer object comparator";

    private final JsonCompareResult result = new JsonCompareResult();

    @Override
    public JsonCompareResult detectDiff(Object expect, Object actual) {
        // pre-check
        if (!check(expect, actual, result, travelPath)) {
            return result;
        }
        result.setDefectsList(ListUtil.of(new Defects().setIllustrate(ILLUSTRATE_MSG)));
        result.setMatch(false);
        return result;
    }
}
