package me.codeleep.jsondiff.test;


import com.alibaba.fastjson2.JSON;
import me.codeleep.jsondiff.common.model.JsonCompareResult;
import me.codeleep.jsondiff.common.model.JsonComparedOption;
import me.codeleep.jsondiff.core.DefaultJsonDifference;
import me.codeleep.jsondiff.core.config.JsonDiffOption;

/**
 * @author: codeleep
 * @createTime: 2022/11/22 16:57
 * @description:
 */
public class Test {

    public static void main(String[] args) {
        String array1 = "[1, 2, 3, 4, 5]";
        String array2 = "[1, 3, 9, 4, 5]";

        // 注册自定义比较器
        JsonDiffOption.getJsonNeatFactory().addCustomComparator("path", MyArrayJsonDiff.class);
        // 其余配置
        JsonComparedOption jsonComparedOption = new JsonComparedOption().setIgnoreOrder(true);
        JsonCompareResult jsonCompareResult = new DefaultJsonDifference()
                .option(jsonComparedOption)
                .detectDiff(JSON.parseArray(array1), JSON.parseArray(array2));
        System.out.println(JSON.toJSONString(jsonCompareResult));
    }
}
