/*
 * Decompiled with CFR 0.152.
 */
package me.codeleep.jsondiff.test.dataFactory;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.codeleep.jsondiff.common.model.JsonComparedOption;
import me.codeleep.jsondiff.test.model.MetaData;
import me.codeleep.jsondiff.test.utils.ResourceUtils;

public class FactoryUtil {
    public static void load(String path, String[] loadDataName, Map<String, Integer> maxMap, Map<String, ArrayList<MetaData>> arrayData) {
        String expectContent = ResourceUtils.loadResourceLine(path);
        JSONObject jsonObject = (JSONObject)JSON.parse((String)expectContent);
        for (String name : loadDataName) {
            arrayData.put(name, FactoryUtil.JsonArrayToMetadataList(jsonObject.getJSONArray(name), name, maxMap));
        }
    }

    private static ArrayList<MetaData> JsonArrayToMetadataList(JSONArray jsonArray, String type, Map<String, Integer> maxMap) {
        ArrayList<MetaData> list = new ArrayList<MetaData>();
        int count = 0;
        for (Object i : jsonArray) {
            JSONObject jsonObject = (JSONObject)i;
            MetaData metaData = new MetaData(jsonObject.getString("caseName"), jsonObject.get("expect"), jsonObject.get("actual"), jsonObject.get("ret"), FactoryUtil.getOptionObject((JSONObject)jsonObject.get("option")));
            list.add(metaData);
            ++count;
        }
        maxMap.put(type, count);
        return list;
    }

    private static JsonComparedOption getOptionObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        JsonComparedOption jsonComparedOption = new JsonComparedOption();
        boolean ignoreOrder = false;
        try {
            ignoreOrder = jsonObject.getBoolean("ignoreOrder") != null && jsonObject.getBoolean("ignoreOrder") != false;
        }
        catch (ExceptionInInitializerError e) {
            e.printStackTrace();
        }
        jsonComparedOption.setIgnoreOrder(ignoreOrder);
        String mapping = jsonObject.getString("mapping");
        if (mapping != null && !mapping.isEmpty()) {
            jsonComparedOption.setMapping((Map)((HashMap)JSONObject.parseObject((String)mapping, Map.class)));
        }
        jsonComparedOption.setIgnorePath(FactoryUtil.ArrStringToSet(jsonObject.getString("ignorePath")));
        jsonComparedOption.setIgnoreKey(FactoryUtil.ArrStringToSet(jsonObject.getString("ignoreKey")));
        return jsonComparedOption;
    }

    private static HashSet<String> ArrStringToSet(String stringList) {
        if (stringList == null || stringList.isEmpty()) {
            return null;
        }
        List arrayList = JSON.parseArray((String)stringList, String.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
        return new HashSet<String>(arrayList);
    }
}

