/*
 * Decompiled with CFR 0.152.
 */
package me.codeleep.jsondiff.test;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import me.codeleep.jsondiff.common.model.JsonCompareResult;
import me.codeleep.jsondiff.core.DefaultJsonDifference;
import me.codeleep.jsondiff.test.dataFactory.ArrayDataFactory;
import me.codeleep.jsondiff.test.model.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MultAllArrayTest {
    private static final Logger logger = LoggerFactory.getLogger(MultAllArrayTest.class);

    @Test(dataProvider="right", dataProviderClass=ArrayDataFactory.class)
    public void noOptionRightTest(MetaData metaData) {
        DefaultJsonDifference defaultJsonDifference = new DefaultJsonDifference();
        logger.info(metaData.getCaseName());
        logger.debug("\n" + metaData.getExpect().toString() + "\n" + metaData.getActual().toString());
        JsonCompareResult jsonCompareResult = defaultJsonDifference.detectDiff((JSONArray)metaData.getExpect(), (JSONArray)metaData.getActual());
        if (metaData.getRet() != null) {
            Assert.assertEquals((String)JSON.toJSONString((Object)jsonCompareResult), (String)JSON.toJSONString((Object)metaData.getRet()));
        } else {
            Assert.assertEquals((String)JSON.toJSONString((Object)jsonCompareResult), (String)"{\"match\":true}");
        }
    }

    @Test(dataProvider="err", dataProviderClass=ArrayDataFactory.class)
    public void noOptionErrTest(MetaData metaData) {
        DefaultJsonDifference defaultJsonDifference = new DefaultJsonDifference();
        logger.info(metaData.getCaseName());
        logger.debug("\n" + metaData.getExpect().toString() + "\n" + metaData.getActual().toString() + "\n" + metaData.getOption());
        JsonCompareResult jsonCompareResult = defaultJsonDifference.detectDiff((JSONArray)metaData.getExpect(), (JSONArray)metaData.getActual());
        Assert.assertEquals((String)JSON.toJSONString((Object)jsonCompareResult), (String)JSON.toJSONString((Object)metaData.getRet()));
    }

    @Test(dataProvider="optionRight", dataProviderClass=ArrayDataFactory.class)
    public void optionRight(MetaData metaData) {
        DefaultJsonDifference defaultJsonDifference = new DefaultJsonDifference();
        logger.info(metaData.getCaseName());
        logger.debug("\n" + metaData.getExpect().toString() + "\n" + metaData.getActual().toString() + "\n");
        JsonCompareResult jsonCompareResult = defaultJsonDifference.option(metaData.getOption()).detectDiff((JSONArray)metaData.getExpect(), (JSONArray)metaData.getActual());
        if (metaData.getRet() != null) {
            Assert.assertEquals((String)JSON.toJSONString((Object)jsonCompareResult), (String)JSON.toJSONString((Object)metaData.getRet()));
        } else {
            Assert.assertEquals((String)JSON.toJSONString((Object)jsonCompareResult), (String)"{\"match\":true}");
        }
    }

    @Test(dataProvider="optionErr", dataProviderClass=ArrayDataFactory.class)
    public void optionErr(MetaData metaData) {
        DefaultJsonDifference defaultJsonDifference = new DefaultJsonDifference();
        logger.info(metaData.getCaseName());
        logger.debug("\n" + metaData.getExpect().toString() + "\n" + metaData.getActual().toString() + "\n");
        JsonCompareResult jsonCompareResult = defaultJsonDifference.option(metaData.getOption()).detectDiff((JSONArray)metaData.getExpect(), (JSONArray)metaData.getActual());
        Assert.assertEquals((String)JSON.toJSONString((Object)jsonCompareResult), (String)JSON.toJSONString((Object)metaData.getRet()));
    }
}

