/*
 * Decompiled with CFR 0.152.
 */
package me.codeleep.jsondiff.impl.gson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Set;
import me.codeleep.jsondiff.common.model.neat.JsonDiff;
import me.codeleep.jsondiff.common.model.neat.JsonDiffObject;
import me.codeleep.jsondiff.impl.gson.GsonArray;
import me.codeleep.jsondiff.impl.gson.GsonOther;
import me.codeleep.jsondiff.impl.gson.GsonPrimitive;

public class GsonObject
implements JsonDiffObject {
    private static final Gson gson = new Gson();
    private final JsonObject jsonObject;

    public GsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JsonDiff get(String key) {
        if (this.jsonObject == null) {
            return null;
        }
        JsonElement value = this.jsonObject.get(key);
        if (value instanceof JsonObject) {
            return new GsonObject((JsonObject)value);
        }
        if (value instanceof JsonArray) {
            return new GsonArray((JsonArray)value);
        }
        if (value instanceof JsonPrimitive) {
            return new GsonPrimitive(value);
        }
        return new GsonOther(value);
    }

    public Set<String> keySet() {
        if (this.jsonObject == null) {
            return new HashSet<String>();
        }
        return this.jsonObject.keySet();
    }

    public Object format() {
        if (this.jsonObject == null) {
            return null;
        }
        return gson.toJson((JsonElement)this.jsonObject);
    }

    public boolean isLeaf() {
        return false;
    }
}

