/*
 * Decompiled with CFR 0.152.
 */
package me.codeleep.jsondiff.impl.gson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import me.codeleep.jsondiff.common.model.neat.JsonDiff;
import me.codeleep.jsondiff.common.model.neat.JsonDiffArray;
import me.codeleep.jsondiff.impl.gson.GsonObject;
import me.codeleep.jsondiff.impl.gson.GsonOther;
import me.codeleep.jsondiff.impl.gson.GsonPrimitive;

public class GsonArray
implements JsonDiffArray {
    private static final Gson gson = new Gson();
    private final JsonArray jsonArray;

    public GsonArray(JsonArray jsonArray) {
        this.jsonArray = jsonArray;
    }

    public int size() {
        if (this.jsonArray == null) {
            return 0;
        }
        return this.jsonArray.size();
    }

    public JsonDiff get(int index) {
        if (this.jsonArray == null) {
            return null;
        }
        JsonElement value = this.jsonArray.get(index);
        if (value instanceof JsonArray) {
            return new GsonArray((JsonArray)value);
        }
        if (value instanceof JsonObject) {
            return new GsonObject((JsonObject)value);
        }
        if (value instanceof JsonPrimitive) {
            return new GsonPrimitive(value);
        }
        return new GsonOther(value);
    }

    public void add(Object item) {
        if (item == null) {
            this.jsonArray.add((JsonElement)JsonNull.INSTANCE);
            return;
        }
        JsonElement jsonTree = gson.toJsonTree(item);
        this.jsonArray.add(jsonTree);
    }

    public void addAll(Collection<?> cs) {
        cs.forEach(this::add);
    }

    public Object format() {
        if (this.jsonArray == null) {
            return null;
        }
        return gson.toJson((JsonElement)this.jsonArray);
    }

    public boolean isLeaf() {
        return false;
    }
}

