/*
 * Decompiled with CFR 0.152.
 */
package me.codeleep.jsondiff.common.utils;

import me.codeleep.jsondiff.common.JsonDiffOption;
import me.codeleep.jsondiff.common.model.JsonComparedOption;

public class RunTimeDataFactory {
    private static final ThreadLocal<JsonComparedOption> optionThreadLocal = new ThreadLocal();

    public static JsonComparedOption getOptionInstance() {
        if (JsonDiffOption.isUniqueOption()) {
            return JsonDiffOption.getGloballyUniqueOption();
        }
        if (optionThreadLocal.get() == null) {
            optionThreadLocal.set(new JsonComparedOption());
        }
        return optionThreadLocal.get();
    }

    public static void setOptionInstance(JsonComparedOption jsonComparedOption) {
        if (jsonComparedOption == null) {
            return;
        }
        optionThreadLocal.remove();
        optionThreadLocal.set(jsonComparedOption);
    }

    public static void clearOptionInstance() {
        optionThreadLocal.remove();
    }
}

