/*
 * Decompiled with CFR 0.152.
 */
package cn.xhteam.boot.http;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HttpServletResponse {
    private Socket socket;
    private int statusCode = 200;
    private String statusReason = "ok";
    private Map<String, Object> headers = new HashMap<String, Object>();
    private File contentFile;
    private ByteArrayOutputStream baos;

    public HttpServletResponse(Socket socket) {
        this.socket = socket;
    }

    public void response() throws IOException {
        this.sendBefore();
        this.sendStatusLine();
        this.sendHeaders();
        this.sendContent();
    }

    private void sendBefore() {
        if (this.baos != null) {
            this.addHeader("Content-Length", this.baos.size() + "");
        }
    }

    private void sendStatusLine() throws IOException {
        this.println("HTTP/1.1 " + this.statusCode + " " + this.statusReason);
    }

    private void sendHeaders() throws IOException {
        Set<Map.Entry<String, Object>> entrySet = this.headers.entrySet();
        for (Map.Entry<String, Object> e : entrySet) {
            String key = e.getKey();
            Object value = e.getValue();
            this.println(key + ": " + value);
        }
        this.println("");
    }

    private void sendContent() throws IOException {
        if (this.baos != null) {
            byte[] data = this.baos.toByteArray();
            OutputStream out = this.socket.getOutputStream();
            out.write(data);
        } else if (this.contentFile != null) {
            try (FileInputStream fis = new FileInputStream(this.contentFile);){
                int len;
                OutputStream outputStream = this.socket.getOutputStream();
                byte[] data = new byte[10240];
                while ((len = fis.read(data)) != -1) {
                    outputStream.write(data, 0, len);
                }
            }
        }
    }

    public void sendRedirect(String path) {
        this.statusCode = 302;
        this.statusReason = "Moved Temporarily";
        this.addHeader("Location", path);
    }

    private void println(String line) throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(line.getBytes(StandardCharsets.UTF_8));
        outputStream.write(13);
        outputStream.write(10);
    }

    public void addHeader(String key, Object value) {
        this.headers.put(key, value);
    }

    public void setContentFile(File contentFile) throws IOException {
        this.contentFile = contentFile;
        String contentType = Files.probeContentType(contentFile.toPath());
        if (contentType != null) {
            this.addHeader("Content-Type", contentType);
        }
        this.addHeader("Content-Length", contentFile.length());
    }

    public OutputStream getOutputStream() {
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream();
        }
        return this.baos;
    }

    public PrintWriter getWriter() {
        PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.getOutputStream(), StandardCharsets.UTF_8)), true);
        return pw;
    }

    public void setContentType(String mime) {
        this.addHeader("Content-Type", mime);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public File getContentFile() {
        return this.contentFile;
    }
}

