/*
 * Decompiled with CFR 0.152.
 */
package cn.xhteam.boot.http;

import cn.xhteam.boot.http.EmptyRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpServletRequest {
    public static final Logger logger = LogManager.getLogger();
    public static String POST = "POST";
    public static String GET = "GET";
    private Socket socket;
    private String method;
    private String uri;
    private String protocol;
    private String requestURI;
    private String queryString;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String paramBody;
    private Map<String, Object> headers = new HashMap<String, Object>();

    public HttpServletRequest(Socket socket) throws IOException, EmptyRequestException {
        this.socket = socket;
        this.parseRequestLine();
        this.parseHeaders();
        this.parseContent();
    }

    private void parseRequestLine() throws IOException, EmptyRequestException {
        String line = this.readLine();
        if (line.isEmpty()) {
            throw new EmptyRequestException();
        }
        String[] data = line.split("\\s");
        this.method = data[0];
        this.uri = data[1];
        this.protocol = data[2];
        logger.error("protocol=" + this.protocol + ("\tmethod=" + this.method) + ("\turi=" + this.uri));
        this.parseURI();
    }

    private void parseURI() {
        String[] data = this.uri.split("\\?");
        this.requestURI = data[0];
        if (data.length > 1) {
            this.queryString = data[1];
            this.parseParameters(this.queryString);
        }
    }

    private void parseParameters(String line) {
        String[] data;
        try {
            line = URLDecoder.decode(line, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        for (String e : data = line.split("&")) {
            String[] paras = e.split("=");
            String val = paras.length > 1 ? paras[1] : "";
            this.parameters.put(paras[0], val);
        }
    }

    private void parseHeaders() throws IOException {
        String line;
        while (!(line = this.readLine()).isEmpty()) {
            String[] data = line.split(":\\s");
            this.headers.put(data[0].toLowerCase(Locale.ROOT), data[1]);
        }
    }

    private void parseContent() throws IOException {
        Object contentLength;
        if (POST.equalsIgnoreCase(this.method) && (contentLength = this.getHeader("Content-Length")) != null) {
            String line;
            int length = Integer.parseInt(contentLength.toString());
            byte[] data = new byte[length];
            InputStream in = this.socket.getInputStream();
            in.read(data);
            Object contentType = this.getHeader("Content-Type");
            if ("application/x-www-form-urlencoded".equals(contentType)) {
                line = new String(data, StandardCharsets.ISO_8859_1);
                this.parseParameters(line);
            }
            if ("application/json".equals(contentType)) {
                this.paramBody = line = new String(data, StandardCharsets.UTF_8);
            }
        }
    }

    private String readLine() throws IOException {
        int d;
        InputStream is = this.socket.getInputStream();
        int cur = 97;
        int pre = 97;
        StringBuilder builder = new StringBuilder();
        while ((d = is.read()) != -1) {
            cur = (char)d;
            if (pre == 13 && cur == 10) break;
            builder.append((char)cur);
            pre = cur;
        }
        return builder.toString().trim();
    }

    public Object getHeader(String name) {
        return this.headers.get(name.toLowerCase(Locale.ROOT));
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public Object getParamBody() {
        return this.paramBody;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String url) {
        this.uri = url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getQueryString() {
        return this.queryString;
    }
}

