/*
 * Decompiled with CFR 0.152.
 */
package cn.xhteam.boot.core;

import cn.xhteam.boot.annotation.RequestParam;
import cn.xhteam.boot.core.HandMapping;
import cn.xhteam.boot.http.HttpServletRequest;
import cn.xhteam.boot.http.HttpServletResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URISyntaxException;
import java.util.Date;

public class DispatcherServlet {
    private static DispatcherServlet dispatcherServlet = new DispatcherServlet();
    private static File rootDir;
    private static File staticDir;

    private DispatcherServlet() {
    }

    public Object[] getRequestParam(HttpServletRequest request, Method method) {
        Object[] objects = new Object[method.getParameterCount()];
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            RequestParam requestParam;
            Object param = null;
            if (HttpServletRequest.GET.equalsIgnoreCase(request.getMethod()) && null != (requestParam = parameters[i].getAnnotation(RequestParam.class))) {
                param = request.getParameter(requestParam.value());
            }
            if (HttpServletRequest.POST.equalsIgnoreCase(request.getMethod())) {
                try {
                    Class<?> parameterType = parameters[i].getType();
                    param = null != request.getParamBody() ? JSON.parseObject((String)request.getParamBody().toString(), parameterType) : parameterType.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            objects[i] = param;
        }
        return objects;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getRequestURI();
        try {
            Method method = HandMapping.getMethod(path);
            if (method != null) {
                Object[] args = this.getRequestParam(request, method);
                Object object = method.invoke(method.getDeclaringClass().newInstance(), args);
                response.setStatusCode(200);
                response.setContentType("application/json; charset=utf-8");
                response.addHeader("Access-Control-Allow-Credentials", true);
                response.addHeader("Access-Control-Allow-Headers", "Content-Type");
                PrintWriter out = response.getWriter();
                String json = JSON.toJSONString((Object)object, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.QuoteFieldNames});
                out.print(json);
                out.close();
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File file = new File(staticDir, path);
        if (file.isFile()) {
            response.setContentFile(file);
        } else {
            response.setStatusCode(404);
            response.setStatusReason("NotFound");
            response.setContentType("text/html;charset = utf-8");
            PrintWriter out = response.getWriter();
            out.write("<html><body><h1>Whitelabel Error Page</h1><p>This application has no explicit mapping for /error, so you are seeing this as a fallback.</p><div id='created'>" + new Date() + "</div><div>There was an unexpected error (type=Not Found, status=404).</div><div>No message available</div></body></html>");
            out.close();
        }
    }

    public static DispatcherServlet getDispatcherServlet() {
        return dispatcherServlet;
    }

    static {
        try {
            rootDir = new File(DispatcherServlet.class.getClassLoader().getResource(".").toURI());
            staticDir = new File(rootDir, "static");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

