/*
 * Decompiled with CFR 0.152.
 */
package cn.xhteam.boot.core;

import cn.xhteam.boot.annotation.Controller;
import cn.xhteam.boot.annotation.RequestMapping;
import cn.xhteam.boot.core.ClientHandler;
import cn.xhteam.boot.core.DispatcherServlet;
import cn.xhteam.boot.core.HandMapping;
import cn.xhteam.boot.util.FileClassUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CatBootApplication {
    public static final Logger logger = LogManager.getLogger();
    private ServerSocket serverSocket;
    protected static Class BootClass;
    private ExecutorService executorService;
    private Properties props;

    public void getPropConfig() {
        try {
            File file = new File(new File(DispatcherServlet.class.getClassLoader().getResource(".").toURI()), "application.properties");
            this.props = new Properties();
            if (file.exists()) {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                this.props.load(bis);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public CatBootApplication() {
        try {
            String[] banner;
            this.getPropConfig();
            logger.error("start server loadding...");
            for (String line : banner = new String[]{"    /\\_/\\", "   / o o \\", "  (   \"   )", "   \\~(*)~/", "    - ^ -", "BBBBB  OOOOO  OOOOO  TTTTTTT", "B    B O    O O    O    T   ", "BBBBB  O    O O    O    T   ", "B    B O    O O    O    T   ", "BBBBB  OOOOO  OOOOO     T   "}) {
                System.out.println(line);
            }
            String prot = this.props.getProperty("server.prot", "8080");
            this.serverSocket = new ServerSocket(Integer.valueOf(prot));
            String threadPool = this.props.getProperty("server.thread.pool", String.valueOf(100));
            this.executorService = Executors.newFixedThreadPool(Integer.parseInt(threadPool));
            CatBootApplication.init();
            logger.error("start server sucess!\tthread pool:" + threadPool + " \taddress\uff1ahttp://" + InetAddress.getLocalHost().getHostAddress() + ":" + prot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void init() {
        try {
            List<Class<?>> classObjs = CatBootApplication.scanControllers();
            for (Class<?> classObj : classObjs) {
                Controller controller = classObj.getAnnotation(Controller.class);
                String cv = controller.value();
                Method[] methods = classObj.getDeclaredMethods();
                logger.error("\u626b\u63cfcontroller\u7c7b\u52a0\u8f7d\u5668\uff1a" + classObj.getName() + "\tmethods count --->\t" + methods.length);
                for (Method method : methods) {
                    if (!method.isAnnotationPresent(RequestMapping.class)) continue;
                    RequestMapping rm = method.getAnnotation(RequestMapping.class);
                    String value = rm.value();
                    if (null != cv) {
                        value = cv + value;
                    }
                    HandMapping.putMethod(value, method);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<Class<?>> scanControllers() {
        List<Class<?>> list = FileClassUtil.getClasses(BootClass.getPackage().getName());
        Iterator<Class<?>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Class<?> cls = iterator.next();
            if (cls.isAnnotationPresent(Controller.class)) continue;
            iterator.remove();
        }
        return list;
    }

    public void start() {
        try {
            while (true) {
                Socket socket = this.serverSocket.accept();
                ClientHandler handler = new ClientHandler(socket);
                this.executorService.execute(handler);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void run(Class cls, String[] args) {
        BootClass = cls;
        CatBootApplication application = new CatBootApplication();
        application.start();
    }
}

