package cn.xhteam.boot.core;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.*;

/**
 * 使用当前类维护所有请求对对应的Controller的处理业务方法
 */
public class HandMapping {
    private static Map<String, Method> mapping = new HashMap<>();
    private static File rootDir; //定位应用项目中启动类所在的包

    static {
        try {
            rootDir = new File(CatBootApplication.BootClass.getResource(".").toURI());
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }


    public static Method getMethod(String path) {
        return mapping.get(path);
    }

    public static void putMethod(String path, Method method) {
        mapping.put(path, method);
    }
}