package cn.xhteam.boot.core;

import com.alibaba.fastjson.JSON;
import cn.xhteam.boot.annotation.RequestParam;
import cn.xhteam.boot.http.HttpServletRequest;
import cn.xhteam.boot.http.HttpServletResponse;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URISyntaxException;
import java.util.Date;

/**
 * 处理请求：
 * DispatcherServlet是Spring MVC框架提供的一个核心类，用于和底层容器TOMCAT整合使用。
 * 通过它使得程序员在写业务类时，无需再关注请求是如何调用到对应的业务处理类(某Controller)中
 * 对应的处理方法(被@RequestMapping注解标注的方法)，其会根据请求自动调用。
 * 这里忽略了Tomcat和SpringMVC框架整合的细节，直接使用该类完成核心业务逻辑的剖析。
 */
public class DispatcherServlet {
    private static DispatcherServlet dispatcherServlet;
    private static File rootDir;
    private static File staticDir;

    static {
        dispatcherServlet = new DispatcherServlet();
        try {
            rootDir = new File(DispatcherServlet.class.getClassLoader().getResource(".").toURI());
            staticDir = new File(rootDir, "static");
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    //私有化构造方法
    private DispatcherServlet() {
    }

    public Object[] getRequestParam(HttpServletRequest request, Method method) {
        Object[] objects = new Object[method.getParameterCount()];
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; i++) {
            Object param = null;
            if (request.GET.equalsIgnoreCase(request.getMethod())) {
                RequestParam requestParam = parameters[i].getAnnotation(RequestParam.class);
                if (null != requestParam) {
                    param = request.getParameter(requestParam.value());
                }
            }
            if (request.POST.equalsIgnoreCase(request.getMethod())) {
                try {
                    Class<?> parameterType = parameters[i].getType();
                    if (null != request.getParamBody())
                        param = JSON.parseObject(request.getParamBody().toString(), parameterType);
                    else
                        param = parameterType.newInstance();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            objects[i] = param;
        }
        return objects;
    }


    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getRequestURI();
        try {
            Method method = HandMapping.getMethod(path);
            if (method != null) {
                Object[] args = getRequestParam(request, method);
                Object object = method.invoke(method.getDeclaringClass().newInstance(), args);
                response.setStatusCode(200);
                response.setContentType("application/json; charset=utf-8");
                response.addHeader("Access-Control-Allow-Credentials", true);
                response.addHeader("Access-Control-Allow-Headers", "Content-Type");
                PrintWriter out = response.getWriter();
                String json = JSON.toJSONString(object, SerializerFeature.WRITE_MAP_NULL_FEATURES, SerializerFeature.QuoteFieldNames);
                out.print(json);
                out.close();
                return;
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        File file = new File(staticDir, path);
        if (file.isFile()) {
            response.setContentFile(file);
        } else {
            response.setStatusCode(404);
            response.setStatusReason("NotFound");
            response.setContentType("text/html;charset = utf-8");
            PrintWriter out = response.getWriter();
            out.write("<html><body><h1>Whitelabel Error Page</h1><p>This application has no explicit mapping for /error, so you are seeing this as a fallback.</p><div id='created'>" + new Date() + "</div><div>There was an unexpected error (type=Not Found, status=404).</div><div>No message available</div></body></html>");
            out.close();
        }
    }

    public static DispatcherServlet getDispatcherServlet() {
        return dispatcherServlet;
    }
}